#!/bin/sh

ZEXY_H=z_zexy.h
ZEXY_C=z_zexy.c


GREP=grep
AWK=awk
SED=sed

#################################
## functions

function head_h() {
 echo "/* zexy-setup autogenerated header-file"
 echo " * generated by \"$0\""
 echo " * !! DO NOT MANUALLY EDIT  !!"
 echo " */"
 echo
 echo "#ifndef Z_ZEXY_H__"
 echo "#define Z_ZEXY_H__"
}

function foot_h() {
 echo ""
 echo "void z_zexy_setup(void);"
 echo "#endif /* Z_ZEXY_H__ */"
 echo ""
}

function head_c() {
 echo "/* zexy-setup autogenerated setup-file"
 echo " * generated by \"$0\""
 echo " * !! DO NOT MANUALLY EDIT  !!"
 echo " */"
 echo 
 echo "#include \"$ZEXY_H\""
 echo
 echo "void z_zexy_setup(void)"
 echo "{"
}

function foot_c() {
 echo "}"
 echo
}

##################################
## body

head_h > $ZEXY_H
head_c > $ZEXY_C

for f in `ls *.c | grep -v zexy.c`
do
## each c-file in zexy needs to have a z_<file>_setup()-function
## that calls all needed setup-functions
## any non-alpha-numeric-character is replaced by "_"
## e.g. "multiplex~.c" -> "z_multiplex__setup()"
  i=${f%.c}
  SETUPNAME=$(echo $i | sed -e "s/.*0x.*/setup_&/g" -e "s/~/_tilde/g" -e "/0x/! s/.*/&_setup/")
  if grep -w ${SETUPNAME} $f > /dev/null; then
   echo "void ${SETUPNAME}(void); /* $i */" >> $ZEXY_H
   echo "	${SETUPNAME}(); /* $i */" >> $ZEXY_C
  fi
done

foot_h >> $ZEXY_H
foot_c >> $ZEXY_C

