/* Copyright (c) 1997-1999 Miller Puckette and others.
* For information on usage and redistribution, and for a DISCLAIMER OF ALL
* WARRANTIES, see the file, "LICENSE.txt," in this distribution.  */

/* sampling */

/* Version 0.1: */
/* customized tabwrite~ object by Orm Finnendahl February 2004*/


/* Version 0.2: */
/* rewrote for 64bit cleanness. Orm Finnendahl December 2007*/

#include "m_pd.h"

#define OFTWT_VERSION          "0.2"

/* ------------------------- of_tabwrite~ -------------------------- */

static t_class *of_tabwrite_tilde_class;

typedef struct _of_tabwrite_tilde
{
    t_object x_obj;
    t_outlet *x_bangout;
    t_outlet *x_phaseout;
    t_outlet *x_remainout;
    int x_phase;
    int x_startphase;
    int x_endphase;
    int x_nsampsintab;
  short x_paused;
    t_word *x_vec;
    t_symbol *x_arrayname;
    t_clock *x_clock;
    float x_f;
} t_of_tabwrite_tilde;

static void of_tabwrite_tilde_tick(t_of_tabwrite_tilde *x);

static void *of_tabwrite_tilde_new(t_symbol *s)
{
    t_of_tabwrite_tilde *x = (t_of_tabwrite_tilde *)pd_new(of_tabwrite_tilde_class);
    x->x_phaseout = outlet_new(&x->x_obj, &s_float);
    x->x_remainout = outlet_new(&x->x_obj, &s_float);
    x->x_bangout = outlet_new(&x->x_obj, &s_bang);
    x->x_clock = clock_new(x, (t_method)of_tabwrite_tilde_tick);
    x->x_phase = 0x7fffffff;
    x->x_arrayname = s;
    x->x_f = 0;
    x->x_startphase = 0;
    x->x_endphase = -1;
    x->x_paused = 0;
    return (x);
}

static t_int *of_tabwrite_tilde_perform(t_int *w)
{
    t_of_tabwrite_tilde *x = (t_of_tabwrite_tilde *)(w[1]);
    t_float *in = (t_float *)(w[2]);
    int n = (int)(w[3]), phase = x->x_phase, endphase = x->x_endphase;
    if (!x->x_vec) goto bad;
    
    if ((endphase > phase) && (!x->x_paused))
    {
    	int nxfer = endphase - phase;
    	t_word *fp = x->x_vec + phase;
    	if (nxfer > n) nxfer = n;
    	phase += nxfer;
    	while (nxfer--)
	{
	    float f = *in++;
    	    if (PD_BIGORSMALL(f))
	    	f = 0;
	    (fp++)->w_float = f;
    	}
	if (phase >= endphase)
    	{
    	    clock_delay(x->x_clock, 0);
    	    phase = 0x7fffffff;
	    outlet_bang(x->x_bangout);
    	}
    	x->x_phase = phase;
    }
bad:
    return (w+4);
}

void of_tabwrite_tilde_set(t_of_tabwrite_tilde *x, t_symbol *s)
{
    t_garray *a;

    x->x_arrayname = s;
    if (!(a = (t_garray *)pd_findbyclass(x->x_arrayname, garray_class)))
    {
    	if (*s->s_name) pd_error(x, "of_tabwrite~: %s: no such array",
    	    x->x_arrayname->s_name);
    	x->x_vec = 0;
    }
    else if (!garray_getfloatarray(a, &x->x_nsampsintab, &x->x_vec))
    {
    	error("%s: bad template for of_tabwrite~", x->x_arrayname->s_name);
    	x->x_vec = 0;
    }
    else garray_usedindsp(a);
}

static void of_tabwrite_tilde_dsp(t_of_tabwrite_tilde *x, t_signal **sp)
{
    of_tabwrite_tilde_set(x, x->x_arrayname);
    dsp_add(of_tabwrite_tilde_perform, 3, x, sp[0]->s_vec, sp[0]->s_n);
}

static void of_tabwrite_tilde_bang(t_of_tabwrite_tilde *x)
{
  if (x->x_phase == 0x7fffffff)
    x->x_phase = x->x_startphase;
  if (x->x_endphase == -1) 
    x->x_endphase = x->x_nsampsintab;
  x->x_paused = 0;
  outlet_float(x->x_remainout, (x->x_endphase - x->x_phase));
  outlet_float(x->x_phaseout, x->x_phase);
}

static void of_tabwrite_tilde_goto(t_of_tabwrite_tilde *x, float startphase)
{
  if ((int) startphase < 0)
    x->x_startphase = 0;
  else 
    if ((int) startphase > x->x_nsampsintab)
      x->x_startphase = 0x7fffffff;
    else
      x->x_startphase = (int) startphase;
}

static void of_tabwrite_tilde_range(t_of_tabwrite_tilde *x, float startphase, float endphase)
{
  if ((int) startphase < 0)
    x->x_startphase = 0;
  else {
    if ((int) startphase > x->x_nsampsintab)
      x->x_startphase = 0x7fffffff;
    else
      x->x_startphase = (int) startphase;
  }
  if (((int) endphase < 0) || ((int) endphase > x->x_nsampsintab))
    x->x_endphase = -1;
  else {
    x->x_endphase = (int) endphase;
  }
}

static void of_tabwrite_tilde_stop(t_of_tabwrite_tilde *x)
{
    if (x->x_phase != 0x7fffffff)
    {
    	of_tabwrite_tilde_tick(x);
    	x->x_phase = 0x7fffffff;
    }
}

static void of_tabwrite_tilde_pause(t_of_tabwrite_tilde *x)
{
  if (x->x_phase != 0x7fffffff) {
    of_tabwrite_tilde_tick(x);
    x->x_paused = 1;
  }
}

static void of_tabwrite_tilde_tick(t_of_tabwrite_tilde *x)
{
    t_garray *a = (t_garray *)pd_findbyclass(x->x_arrayname, garray_class);
    if (!a) bug("of_tabwrite_tilde_tick");
    else garray_redraw(a);
}

static void of_tabwrite_tilde_free(t_of_tabwrite_tilde *x)
{
    clock_free(x->x_clock);
}

void of_tabwrite_tilde_setup(void)
{
  post("of_tabwrite~ version %s loaded", OFTWT_VERSION);
    of_tabwrite_tilde_class = class_new(gensym("of_tabwrite~"),
    	(t_newmethod)of_tabwrite_tilde_new, (t_method)of_tabwrite_tilde_free,
    	sizeof(t_of_tabwrite_tilde), 0, A_DEFSYM, 0);
    CLASS_MAINSIGNALIN(of_tabwrite_tilde_class, t_of_tabwrite_tilde, x_f);
    class_addmethod(of_tabwrite_tilde_class, (t_method)of_tabwrite_tilde_dsp,
    	gensym("dsp"), 0);
    class_addmethod(of_tabwrite_tilde_class, (t_method)of_tabwrite_tilde_set,
    	gensym("set"), A_SYMBOL, 0);
    class_addmethod(of_tabwrite_tilde_class, (t_method)of_tabwrite_tilde_goto,
    	gensym("goto"), A_FLOAT, 0);
    class_addmethod(of_tabwrite_tilde_class, (t_method)of_tabwrite_tilde_range,
    	gensym("range"), A_FLOAT, A_FLOAT, 0);
    class_addmethod(of_tabwrite_tilde_class, (t_method)of_tabwrite_tilde_stop,
    	gensym("stop"), 0);
    class_addmethod(of_tabwrite_tilde_class, (t_method)of_tabwrite_tilde_pause,
    	gensym("pause"), 0);
    class_addbang(of_tabwrite_tilde_class, of_tabwrite_tilde_bang);
}
